/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateLoader {
    private static final ILogger log = Log.getLogger(CertificateLoader.class);
    private static final String BEGIN_PRIVATE_KEY_TAG = "PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY_TAG = "-----END";

    public static Certificate[] loadCertificatesFromX509PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory f = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certChain = f.generateCertificates(inputStream);
        return certChain.toArray(new Certificate[certChain.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] loadCertificatesFromX509PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 PEM certificate chain from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Certificate[] certificateArray = CertificateLoader.loadCertificatesFromX509PEM(inputStream);
            return certificateArray;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static Certificate loadCertificateFromX509PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory f = CertificateFactory.getInstance("X.509");
        return f.generateCertificate(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate loadCertificateFromX509PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 PEM certificate from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Certificate certificate = CertificateLoader.loadCertificateFromX509PEM(inputStream);
            return certificate;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey loadKeyFromPKCS8PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] rawBytes = CertificateLoader.readFully(inputStream);
        String rawText = new String(rawBytes);
        int beginIndex = rawText.indexOf(BEGIN_PRIVATE_KEY_TAG);
        if (beginIndex < 0) {
            throw new GeneralSecurityException("Could not find private key beginning tag");
        }
        beginIndex += BEGIN_PRIVATE_KEY_TAG.length();
        int endIndex = rawText.indexOf(END_PRIVATE_KEY_TAG);
        if (endIndex < 0) {
            throw new GeneralSecurityException("Could not find private key ending tag");
        }
        if (beginIndex >= endIndex) {
            throw new GeneralSecurityException("Could not find private key text");
        }
        String base64Text = rawText.substring(beginIndex, endIndex);
        byte[] base64Bytes = base64Text.getBytes();
        if (!Base64.isArrayByteBase64((byte[])base64Bytes)) {
            throw new GeneralSecurityException("Could not decode key text: unrecognizable Base64 encoding");
        }
        byte[] keyBytes = Base64.decodeBase64((byte[])base64Bytes);
        return CertificateLoader.createKeyFromPKCS8Bytes(keyBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromPKCS8PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading PKCS#8 PEM private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromPKCS8PEM(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey loadKeyFromPKCS8DER(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] encodedKey = CertificateLoader.readFully(inputStream);
        return CertificateLoader.createKeyFromPKCS8Bytes(encodedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromPKCS8DER(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading PKCS#8 DER private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromPKCS8DER(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey createKeyFromPKCS8Bytes(byte[] encodedKey) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static Collection<? extends CRL> loadCRLFromPEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCRLs(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends CRL> loadCRLFromPEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading CRL PEM from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Collection<? extends CRL> collection = CertificateLoader.loadCRLFromPEM(inputStream);
            return collection;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((length = inputStream.read(buf)) >= 0) {
            bytesStream.write(buf, 0, length);
        }
        return bytesStream.toByteArray();
    }
}

