package sample;

import com.genesyslab.platform.management.protocol.ApplicationExecutionMode;
import com.genesyslab.platform.management.protocol.ApplicationStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventHostUnderControl;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventNoControllingSCS;
import com.genesyslab.platform.applicationblocks.com.objects.CfgApplication;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;

import java.util.ResourceBundle;
import java.util.PropertyResourceBundle;
import java.io.FileInputStream;


public class SampleServerApp extends AbstractServerApp {

	private static ILogger logger;
    private int lcaPort;
    private String clientName;
    private String cfgHost;
    private int cfgPort;
    private String cfgUserName;
    private String cfgUserPwd;
    private CfgApplication cfgApp;

    
    protected static void log(final String msg) {
    	if(logger== null)
    		logger = Log.getLogger("SampleServerApp");
    	logger.info(msg);       
    }


    public static void main(final String[] args) throws Exception {
    	try
    	{	        	        
	        SampleServerApp theApp = new SampleServerApp();
	        theApp.Init();
	        theApp.Execute();
    	}
    	catch(Exception e)	{     		
    		log(e.toString());
    	}   
    } 

    /**
     * Run application and report it's state to Management Framework.
     */
    public void Execute() throws Exception {
    	        
        openLCA(lcaPort,
        		cfgApp.getType().ordinal(),
        		cfgApp.getName(),
        		cfgApp.getDBID()
        );
        log("LCA connection opened");

        // Perform some application initialization while MF treat its state as "Initializing".
        // ...
        Thread.sleep(1500);
        log("Application started");

        // Then application should report that initialization is finished:
        doUpdateStatus(getExecutionMode(), ApplicationStatus.Running);
        log("Application is \"running\"");
        // After this SCS through LCA may send request to change execution mode.
        // Initially applications start as "Primary", but when particular application
        // is configured in primary/backup pair, and 

        while (getExecutionMode() != ApplicationExecutionMode.Exiting) {
            Thread.sleep(500);
        }

        log("Application is stopping");
        // Report application stopped status:
        doUpdateStatus(getExecutionMode(), ApplicationStatus.Stopped);

        closeLCA();
        log("LCA closed");
        
    }
    
    /**
     * Read application settings from configuration file.
     */
    public void Init() throws Exception {    	    	
        
        log("Reading application properties...");

        ResourceBundle properties = new PropertyResourceBundle(
                            new FileInputStream("SampleServerApp.properties"));
        
        StringBuilder sb = new StringBuilder();
        for (String key : properties.keySet() )  
        {  
        	sb.append(key).append("=").append(properties.getString(key)).append("\n");        	 
        } 
        log("\n"+sb.toString()); 
                         
        clientName = properties.getString("ClientName");
        try
        {
        	lcaPort = Integer.parseInt(properties.getString("LCAPort"));
        }
        catch (Exception e)
        {
            throw new Exception("Invalid LCA port");
        }
                
        cfgHost = properties.getString("ConfigServerHost");
        try
        {
            cfgPort = Integer.parseInt(properties.getString("ConfigServerPort"));
        }
        catch (Exception e)
        {
            throw new Exception("Invalid Configuration Server port");
        }
                  
        cfgUserName = properties.getString("UserName");
        cfgUserPwd = properties.getString("Password");
        
    	//Get application from Configuration server
        cfgApp = RetrieveApplicationConfiguration(cfgHost, 
        		cfgPort, cfgUserName, cfgUserPwd, clientName);
    	
    }
    
    
    /**
    * This method opens connection to Configuration Server, reads application configuration and then closes connection.
    * The {@link CfgApplication} contains application DBID required for communication with LCA.     
    */
       
       private CfgApplication RetrieveApplicationConfiguration(String host, int port, 
       		String UserName, String UserPwd, String appName)   throws Exception 	
       	{
           
    	   ConfigurationAccessor accessor = new ConfigurationAccessor();  
           accessor.Initialize(host, port, UserName, UserPwd, appName);            

           CfgApplication application = null;
           try
           {
               accessor.Connect();
               application = accessor.RetrieveApplication(appName);

               if (application == null)
               {
                   throw new Exception("Specified application not found!");
               }
           }
           catch (Exception e)
           {
               //throw new Exception( "Can't retrieve application! Reason: " + e.getMessage());
        	   throw e;
           }
           finally
           {
               accessor.Disconnect();
           }
           log(String.format("Got application setting from config server: \n Name=%s, \n DBID=%s", application.getName(), application.getDBID()));
           return application;
       }


    
    
    
    @Override
    protected boolean onChangeExecutionMode(
            ApplicationExecutionMode execMode) {
        log("Changing execution mode to " + execMode + "...");
        return true;
    }

    @Override
    protected void onSuspendApplication() {
        log("Do application suspend...");
    }

    @Override
    protected void onLCAConnectionOpened() {
        log("LCA connected");
    }

    @Override
    protected void onLCAConnectionLost(final ChannelClosedEvent event) {
        log("LCA lost");
    }

    @Override
    protected void onHostUnderSCSControl(final EventHostUnderControl event) {
        log("Under SCS control (" + event.getSCSApplicationName() + ")");
    }

    @Override
    protected void onHostOffSCSControl(final EventNoControllingSCS event) {
        log("No SCS control");
    }
}
